package app.firezone.synk.network.ui.videos;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.GridLayoutManager;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.YouTubePlayer;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.AbstractYouTubePlayerListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.YouTubePlayerListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.options.IFramePlayerOptions;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.utils.YouTubePlayerUtils;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.views.YouTubePlayerView;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.Adapter.PlayerUiController;
import app.firezone.synk.network.Adapter.VideoAdapter;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.FragmentVideoBinding;
import app.firezone.synk.network.model.VideoModel;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VideoFragment extends Fragment {

    FragmentVideoBinding binding;
    ArrayList<VideoModel> mlist = new ArrayList<>();
    VideoAdapter adapter;
    Dialog dialog;

    @SuppressLint("MissingInflatedId")
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        binding = FragmentVideoBinding.inflate(inflater, container, false);
        View root = binding.getRoot();

        dialog = new Dialog(getContext());
        dialog.setContentView(R.layout.loading_dialog);

        if (dialog.getWindow() != null) {
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(true);
        }
        dialog.show();

        fetchVideosFromApi();

        GridLayoutManager layoutManager = new GridLayoutManager(getContext(), 2);
        binding.videoRecy.setLayoutManager(layoutManager);

        adapter = new VideoAdapter(getContext(), mlist, getViewLifecycleOwner());
        binding.videoRecy.setAdapter(adapter);
        binding.videoRecy.setHasFixedSize(true);

        return root;
    }

    private void fetchVideosFromApi() {
        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<ArrayList<VideoModel>> call = myApi.fetchVideos();

        call.enqueue(new Callback<ArrayList<VideoModel>>() {
            @Override
            public void onResponse(Call<ArrayList<VideoModel>> call, Response<ArrayList<VideoModel>> response) {
                if (response.isSuccessful() && response.body() != null) {
                    mlist.clear();
                    mlist.addAll(response.body());
                    Collections.reverse(mlist);
                    dialog.dismiss();
                    adapter.notifyDataSetChanged();
                    if (!mlist.isEmpty()) {
                        setupYouTubePlayer(mlist.get(0));
                    }
                } else {
                    dialog.dismiss();
                    Toast.makeText(getContext(), "Failed to fetch videos", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<VideoModel>> call, Throwable t) {
                dialog.dismiss();
                Toast.makeText(getContext(), "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void setupYouTubePlayer(VideoModel model) {
        YouTubePlayerView youTubePlayerView = binding.youtubePlayerView;
        getLifecycle().addObserver(youTubePlayerView);
        youTubePlayerView.setEnableAutomaticInitialization(false);

        String videoId = extractYouTubeVideoId(model.getVideourl());

        if (videoId == null || videoId.isEmpty()) {
            Toast.makeText(getContext(), "Invalid video URL", Toast.LENGTH_SHORT).show();
            return;
        }

        View controlUi = youTubePlayerView.inflateCustomPlayerUi(R.layout.custom_controller);
        YouTubePlayerListener youTubePlayerListener = new AbstractYouTubePlayerListener() {
            @Override
            public void onReady(@NonNull YouTubePlayer youTubePlayer) {
                PlayerUiController controller = new PlayerUiController(controlUi, youTubePlayer, youTubePlayerView);
                youTubePlayer.addListener(controller);
                YouTubePlayerUtils.loadOrCueVideo(youTubePlayer, getLifecycle(), videoId, 0F);
            }
        };

        IFramePlayerOptions options = new IFramePlayerOptions.Builder().controls(0).build();
        youTubePlayerView.initialize(youTubePlayerListener, options);
    }

    private String extractYouTubeVideoId(String videoUrl) {
        if (videoUrl == null || videoUrl.trim().isEmpty()) return null;

        String videoId = null;
        try {
            Pattern pattern = Pattern.compile(
                    "(?:https?://)?(?:www\\.)?(?:youtube\\.com|youtu\\.be)/(?:watch\\?v=|embed/|v/|e/|shorts/|live/|.*[?&]v=)?([a-zA-Z0-9_-]{11})",
                    Pattern.CASE_INSENSITIVE
            );

            Matcher matcher = pattern.matcher(videoUrl);
            if (matcher.find()) {
                videoId = matcher.group(1); // Extracts the video ID
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return videoId;
    }

}
